package slitscan.slit;

import java.io.File;
import java.util.Random;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class SquareRandomArea extends OrbitRoot implements Orbit {

	final int size;
	int nx;
	int ny;
	int[] nn;
	Random ri = new Random(1512);
	
	public SquareRandomArea(File[] in_files, String[] args) {
		this.size = checkArg(args, 0) ? Integer.parseInt(args[0]) : 10;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		this.nx = ictx.depth / this.size;
		this.ny = ictx.width / this.size;
		this.nn = new int[(this.nx + 1) * (this.ny + 1) * 10];  // TODO * 10?
		for(int i=0; i<this.nn.length; ++i) {
			this.nn[i] = this.ri.nextInt(ictx.depth);
		}
		this.octx = new ContextOut(ictx.depth, ictx.width);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.ty;
		int tile_x = p.ty / this.size;
//		assert tile_x < this.nx : tile_x;
		int tile_y = p.tx / this.size;
//		if(tile_y >= this.ny) {
//			System.out.println(tile_y+ " " +p.ty+ " " +this.ny+ " " +this.size);
//		}
//		assert tile_y < this.ny : tile_y;
//		p.sz = (p.tx / this.size) * this.size;
		//System.out.println(tile_x*this.ny+tile_y);
		p.sz = this.nn[(int) (tile_x * this.ny + tile_y)];
//		p.sz = this.nn[(int) (tile_x + tile_y * this.nx)];
		p.sy = (int) (((double)p.tx / this.octx.width) * this.ictx.height);
	}

	@Override
	public String toString() {
		return "SquareRandomArea [size=" + this.size + "]";
	}
}
