package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class LinearVerticalSlit extends OrbitRoot implements Orbit {

	final boolean left;
	
	public LinearVerticalSlit(File[] in_files, String[] args) {
		super();
		this.left = checkArg(args, 0) ? args[0].equals("0") : true;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		this.octx = new ContextOut(ictx.width, ictx.height);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.tx;
		p.sy = p.ty;
		if(this.left) {
			p.sz = ((double)p.tx / this.octx.width) * this.ictx.depth;
		}
		else {
			p.sz = (1.0 - (double)p.tx / this.octx.width) * this.ictx.depth;
		}
	}

	@Override
	public String toString() {
		return "LinearVerticalSlit [left=" + this.left + "]";
	}
}
