package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class LinearHorizontalSlit extends OrbitRoot implements Orbit {

	final boolean top;
	
	public LinearHorizontalSlit(File[] in_files, String[] args) {
		this.top = checkArg(args, 0) ? args[0].equals("0") : true;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		this.octx = new ContextOut(ictx.depth, ictx.width);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.ty;
		p.sz = p.tx;
		if(this.top) {
			p.sy = (int) (((double)p.tx / this.octx.width) * this.ictx.height);
		}
		else {
			p.sy = (int) ((1.0 - (double)p.tx / this.octx.width) * this.ictx.height);
		}
	}

	@Override
	public String toString() {
		return "LinearHorizontalSlit [top=" + this.top + "]";
	}
}
