package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class HorizontalTrackerSlit extends OrbitRoot implements Orbit {

	final int smooth;
	final boolean normalized;

	public HorizontalTrackerSlit(File[] in_files, String[] args) {
		super();
		this.smooth = checkArg(args, 0) ? Integer.parseInt(args[0]) : 0;
		this.normalized = checkArg(args, 1) ? !args[1].equals("0") : false;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		this.octx = new ContextOut(ictx.width, ictx.height);
		for(int so=0; so<this.smooth; ++so)
			this.tracker.doSmoothing();
		if(this.normalized)
			this.tracker.normalize();
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.tx;
		p.sy = p.ty;
		p.sz = this.tracker.yNear((double)p.ty / (double)this.ictx.height);
		if(p.tx == 0) System.out.println(p);
	}

	@Override
	public String toString() {
		return "HorizontalTrackerSlit [smooth=" + this.smooth + ", normalized=" + this.normalized + "]";
	}

}
