package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FixedVerticalWideCenterSlit extends OrbitRoot implements Orbit {
	private int where;
	final private int swidth;

	public FixedVerticalWideCenterSlit(File[] in_files, String[] args) {
		this.where = checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
		this.swidth = checkArg(args, 1) ? Integer.parseInt(args[1]) : 1;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		if(this.where < 0)
			this.where = (ictx.width - this.swidth) / 2; 
		this.octx = new ContextOut(ictx.depth*this.swidth, ictx.height);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		int dy = p.ty - this.ictx.height / 2;
		dy = dy < 0 ? -dy : dy;
		double fy = 1.0 - (double)dy / (double)(this.ictx.height / 2);
		int sw =  (int) (fy * this.swidth);
		sw = sw < 1 ? 1 : sw;
		p.sx = this.where + (sw - p.tx % sw - 1);
		p.sy = p.ty;
		p.sz = p.tx / this.swidth;
	}

	@Override
	public String toString() {
		return "FixedVerticalWideCenterSlit [where=" + this.where + ", swidth=" + this.swidth + "]";
	}

}
