package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FixedVerticalSlit extends OrbitRoot implements Orbit {

	private int where;

	public FixedVerticalSlit(File[] in_files, String[] args) {
		this.where = checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		if(this.where < 0) {
			this.where = ictx.width / 2; 
		}
		this.octx = new ContextOut(ictx.depth, ictx.height);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = this.where;
		p.sy = p.ty;
		p.sz = p.tx;
	}

	@Override
	public String toString() {
		return "FixedVerticalSlit [where=" + this.where + "]";
	}
}
