package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FixedHorizontalWideSlit extends OrbitRoot implements Orbit {
	
	private int where;
	final private int swidth;

	public FixedHorizontalWideSlit(File[] in_files, String[] args) {
		this.where = checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
		this.swidth = checkArg(args, 1) ? Integer.parseInt(args[1]) : 1;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		if(this.where < 0)
			this.where = (ictx.height - this.swidth) / 2;
		this.octx = new ContextOut(ictx.depth*this.swidth, ictx.width);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.ty;
		p.sy = this.where + (this.swidth - p.tx % this.swidth - 1);
		p.sz = p.tx / this.swidth;
	}

	@Override
	public String toString() {
		return "FixedHorizontalWideSlit [where=" + this.where + ", swidth=" + this.swidth + "]";
	}

}
