package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FixedHorizontalSlit extends OrbitRoot implements Orbit {
	
	private int where;

	public FixedHorizontalSlit(File[] in_files, String[] args) {
		this.where = checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		if(this.where < 0) {
			this.where = ictx.height / 2;
		}
		this.octx = new ContextOut(ictx.depth, ictx.width);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.ty;
		p.sy = this.where;
		p.sz = p.tx;
	}

	@Override
	public String toString() {
		return "FixedHorizontalSlit [where=" + this.where + "]";
	}
}
