package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class Fixed2HorizontalSlit extends OrbitRoot implements Orbit {
	
	private int where;

	public Fixed2HorizontalSlit(File[] in_files, String[] args) {
		this.where = checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		if(this.where < 0) {
			this.where = ictx.height / 2;
		}
		this.octx = new ContextOut(ictx.depth / 2, 2 * ictx.width);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		if(p.ty % 2 != 0) {
			p.sx = p.ty / 2;
			p.sy = this.where;
			p.sz = 2*p.tx;
		}
		else {
			p.sx = p.ty / 2;
			p.sy = this.where;
			p.sz = 2*p.tx + 1;
		}
	}

	@Override
	public String toString() {
		return "Fixed2HorizontalSlit [where=" + this.where + "]";
	}
}
