package slitscan.slit;

import java.io.File;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FeigenbaumHorizontal extends OrbitRoot implements Orbit {

	final int skip = 100;
	int[] lookup;
	
	static double step(final double p, final double a) {
		return a * p * (1-p);
	}
	
	public FeigenbaumHorizontal(File[] in_files, String[] args) {
		// constructor left empty
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.lookup = new int[ictx.depth*ictx.width];
		double delta_a = 1.0 / ictx.depth;
		for(int ai=0; ai<ictx.depth; ++ai) {
			double min = Double.MAX_VALUE;
			double max = Double.MIN_VALUE;
			double p = 0.3;
			for(int i=0; i<this.skip; ++i) {
				p = step(p, 3.0+delta_a * ai);
			}
			int li = ictx.width * ai;
			for(int j=0; j<ictx.width; ++j) {
				p = step(p, 3.0+delta_a * ai);
				if (p < min)
					min = p;
				if (p > max)
					max = p;
				this.lookup[li++] = (int) (p * ictx.depth);
			}
//			double range = max - min;
//			System.out.println((int)(min*ictx.width) + "\t" + (int)(max*ictx.width) + "\t" + range);
		}
		this.ictx = ictx;
		this.octx = new ContextOut(ictx.depth, ictx.width);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.ty;
		p.sz = this.lookup[this.ictx.width * p.tx];
		p.sy = (int) (((double)p.tx / this.octx.width) * this.ictx.height);
	}

	@Override
	public String toString() {
		return "FeigenbaumHorizontal []";
	}
}
