package slitscan.slit;

import java.io.File;
import java.util.Vector;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class CircularDDA extends OrbitRoot implements Orbit {

	private static final int SLICES = 8;
	final ArgState arg_x0, arg_y0, arg_r;
	int x0, y0, r;
	Vector<Integer> vx, vy;
	int[] tx, ty;
	
	
	public CircularDDA(File[] in_files, String[] args) {
		super();
		this.arg_x0 = checkArgState(args, 0, -1);
		this.arg_y0 = checkArgState(args, 1, -1);
		this.arg_r  = checkArgState(args, 2, -1);
	}
	
	private void append(int x, int y) {
		this.vx.add(x);
		this.vy.add(y);
	}

	private void ddaCircle(int lx0, int ly0, int lr) {
		int x = 0;
		int y = lr;
		double d = 5.0 / 4.0 - lr;
		append(x, y);
		while(y > x) {
			if(d <= 0) {
				d += 2 * x + 3;
				++x;
			}
			else {
				d += 2 * (x - y) + 5;
				++x;
				--y;
			}
			append(x, y);
		}
	}

	private static boolean testDub(int[] tax, int[] tay, int j) {
		for (int i = j-1; i >= 0; i--) {
			if(tax[i] == tax[j] && tay[i] == tay[j])
				return true;
		}
		return false;
	}

	private void buildTable() {
		this.vx = new Vector<Integer>();
		this.vy = new Vector<Integer>();
		ddaCircle(this.x0, this.y0, this.r);
		int[] tax = new int[SLICES * this.vx.size()];
		int[] tay = new int[SLICES * this.vy.size()];
		int j = 0;
		for (int i = 0; i < this.vx.size(); i++) {
			tax[j] = this.vx.get(i) + this.x0;
			tay[j] = this.vy.get(i) + this.y0;
			++j;
		}
		for (int i = this.vx.size() - 1; i >= 0; i--) {
			tax[j] = this.vy.get(i) + this.x0;
			tay[j] = this.vx.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		for (int i = 0; i < this.vx.size(); i++) {
			tax[j] = this.vy.get(i) + this.x0;
			tay[j] = -this.vx.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		for (int i = this.vx.size() - 1; i >= 0; i--) {
			tax[j] = this.vx.get(i) + this.x0;
			tay[j] = -this.vy.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		
		for (int i = 0; i < this.vx.size(); i++) {
			tax[j] = -this.vx.get(i) + this.x0;
			tay[j] = -this.vy.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		for (int i = this.vx.size() - 1; i >= 0; i--) {
			tax[j] = -this.vy.get(i) + this.x0;
			tay[j] = -this.vx.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		for (int i = 0; i < this.vx.size(); i++) {
			tax[j] = -this.vy.get(i) + this.x0;
			tay[j] = this.vx.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		for (int i = this.vx.size() - 1; i >= 0; i--) {
			tax[j] = -this.vx.get(i) + this.x0;
			tay[j] = this.vy.get(i) + this.y0;
			if(!testDub(tax, tay, j))
				++j;
		}
		
		int remove = tax.length - j;
//		System.out.println(tax.length - j);
		this.tx = new int[tax.length - remove];
		java.lang.System.arraycopy(tax, 0, this.tx, 0, tax.length - remove);
		this.ty = new int[tay.length - remove];
		java.lang.System.arraycopy(tay, 0, this.ty, 0, tay.length - remove);

//		int s = 0;
//		for (int p = 0; p < this.tx.length; p++) {
//			if(p % 63 == 0) System.out.println(s++);
//			System.out.println(p + "\t" + (this.tx[p] - this.x0) + "\t" + (this.ty[p] - this.y0));
//		}
		
		this.vx = null;
		this.vy = null;
	}

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		int min = ictx.width;
		if(ictx.height < ictx.width)
			min = ictx.height;
		this.x0 = this.arg_x0.getInt(ictx.width);
		this.y0 = this.arg_y0.getInt(ictx.height);
		this.r  = this.arg_r.getInt(min / 2);
		if(this.x0 < 0) this.x0 = ictx.width / 2;
		if(this.y0 < 0) this.y0 = ictx.height / 2;
		if(this.r < 0) this.r = (min * 2) / 6;
		buildTable();
		this.octx = new ContextOut(ictx.depth, this.tx.length);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sy = this.ty[p.ty];
		p.sx = this.tx[p.ty];
		p.sz = ((double)p.tx / this.octx.width) * this.ictx.depth;
	}

	@Override
	public String toString() {
		return "CircularDDA [x0=" + this.x0 + ", y0=" + this.y0 + ", r=" + this.r + "]";
	}

}
