package slitscan.func;

import java.io.File;

import slitscan.Orbit;

public class SinFunc extends Func implements Orbit {
	
	private final double frequency;
	private final double mx;
	private final double my;

	public SinFunc(File[] in_files, String[] args) {
		this.frequency = checkArg(args, 0) ? Double.parseDouble(args[0]) : 1.0;
		this.mx = checkArg(args, 1) ? Double.parseDouble(args[1]) : 0.0;
		this.my = checkArg(args, 2) ? Double.parseDouble(args[2]) : 0.0;
	}

	public double g(double x, double y) {
		assert x >= 0.0;
		assert x <= 1.0;
		assert y >= 0.0;
		assert y <= 1.0;
		final double xc = x - this.mx;
		final double yc = y - this.my;
		final double rad = 2*Math.PI*Math.sqrt(xc * xc + yc * yc);
		return 0.5 + 0.5 * Math.sin(this.frequency * rad);
	}

	@Override
	public String toString() {
		return "SinFunc [frequency=" + this.frequency + ", mx=" + this.mx + ", my=" + this.my + "]";
	}

}
