package slitscan.func;

import java.io.File;

import slitscan.Orbit;

public class SinCosFunc extends Func implements Orbit {
	
	private final double xFrequency;
	private final double yFrequency;
	private double phase;

	public SinCosFunc(File[] in_files, String[] args) {
		this.xFrequency = checkArg(args, 0) ? Double.parseDouble(args[0]) : 1.0;
		this.yFrequency = checkArg(args, 1) ? Double.parseDouble(args[1]) : 1.0;
		this.phase = checkArg(args, 2) ? Double.parseDouble(args[2]) : 0.0;
	}

	public double g(double x, double y) {
		return 0.5 + 0.25 * (Math.sin(2.0*Math.PI*(this.xFrequency*x+this.phase))
				             + Math.cos(2.0*Math.PI*(this.yFrequency*y+this.phase)));
	}

	@Override
	public String toString() {
		return "SinCosFunc [xFrequency=" + this.xFrequency + ", yFrequency=" + this.yFrequency + ", phase=" + this.phase + "]";
	}

}
