package slitscan.func;

import static org.junit.Assert.*;

import java.io.File;

import org.junit.Test;

public class PerlinNoiseFuncTest {

	private static final int X_SIZE = 1920;
	private static final int Y_SIZE = 1080;
	private static final int STEP = 1;

	@Test
	public void testG() {
		String[] params = {"", Double.toString(1.0 / X_SIZE), Double.toString(1.0 / Y_SIZE), "0.5"};
		PerlinNoiseFunc noiseFunc = new PerlinNoiseFunc(new File[0], params);
		int x = 0;
		while (x < X_SIZE) {
			int y = 0;
			while (y < Y_SIZE) {
				double v = noiseFunc.g(x, y);
				assertTrue("v >= 0.0 : " + v, v >= 0.0 - PerlinNoiseFunc.EPSILON);
				assertTrue("v <  1.0 : " + v, v <  1.0 + PerlinNoiseFunc.EPSILON);
				y += STEP;
			}
			x += STEP;
		}
	}

}
