package slitscan.func;

import java.io.File;
import java.util.Random;

import slitscan.Orbit;

public class NoiseFunc extends Func implements Orbit {
	static final double EPSILON = 0.0001;
	
	private final long seed;
	private final Random r;

	public NoiseFunc(File[] in_files, String[] args) {
		this.seed = checkArg(args, 0) ? Long.parseLong(args[0]) : 1512;
		r = new Random(this.seed);
	}

	public double g(double x, double y) {
		double rad = 2.0 * Math.hypot(x-0.5, y-0.5);
		double v = rad * r.nextDouble();
		if(v < 0.0) return 0.0;
		if(v >= 1.0) return 1.0 - EPSILON;
		return v;
	}

	@Override
	public String toString() {
		return "NoiseFunc [seed=" + seed + "]";
	}

}
