package slitscan.func;

import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public abstract class Func extends OrbitRoot implements Orbit {

	@Override
	public ContextOut buildContextOut(ContextIn ictx) {
		this.ictx = ictx;
		this.octx = new ContextOut(ictx.width, ictx.height);
		return this.octx;
	}
	
	@Override
	public void f(Point p) {
		p.sx = p.tx;
		p.sy = p.ty;
		p.sz = this.ictx.depth * g((double)p.tx / this.ictx.width,
				                   (double)p.ty / this.ictx.height);
	}

	public abstract double g(double x, double y);

}
