package slitscan.func;

import java.io.File;
import java.util.Random;

import slitscan.Orbit;

public class CenterFunc extends Func implements Orbit {
	static final double EPSILON = 0.0001;
	
	private final long seed;
	private double scale;
	private final Random r;


	public CenterFunc(File[] in_files, String[] args) {
		this.seed = checkArg(args, 0) ? Long.parseLong(args[0]) : 1512;
		this.scale = checkArg(args, 1) ? Double.parseDouble(args[1]) : 0.1;
		r = new Random(this.seed);
	}

	public double g(double x, double y) {
		double rad = 2.0 * Math.hypot(x-0.5, y-0.5);
		double v = rad + this.scale * (r.nextDouble() - 0.5);
		if(v < 0.0) return 0.0;
		if(v >= 1.0) return 1.0 - EPSILON;
		return v;
	}

	@Override
	public String toString() {
		return "CenterFunc [seed=" + seed + ", scale=" + scale + "]";
	}

}
