package slitscan.combine;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

import javax.imageio.ImageIO;

import slitscan.ConCombine;
import slitscan.CombineRoot;
class Pixel 
{ 
	final int argb;
    final short gray;
    final short z;

    Pixel(int r, int g, int b, short z) {
    	this.argb = ((r & 0xff) << 16) 
				  | ((g& 0xff) << 8)
				  | ((b & 0xff))
				  | 0xff000000;
		this.gray = toGray(r, g, b);
		this.z = z;
	}

	static short toGray(int r, int g, int b) {
		return (short)(r + g + b);
	}

    @Override
	public String toString() {
		return "Pixel [argb=" + Integer.toHexString(this.argb) + ", gray=" + this.gray + ", z=" + this.z + "]";
	}
} 
  
class Position 
{ 
	final int x, y;
	final Pixel[] pixelList;
	int append;
	Position(int x, int y, int length) {
		this.x = x;
		this.y = y;
		this.append = 0;
		this.pixelList = new Pixel[length];
	}
	
	@Override
	public String toString() {
		return "Position [x=" + this.x + ", y=" + this.y + ", pixelList=" + this.pixelList.length + "]";
	}
} 
  
class SortByGray implements Comparator<Pixel> 
{ 
 
    public int compare(Pixel a, Pixel b) 
    { 
        return a.gray - b.gray; 
    } 
} 

public class Median extends CombineRoot implements ConCombine {
	File[] in_files;
	Position pl[];

	public Median(File[] in_files, String[] args) {
		super();
		this.in_files = in_files;
	}

	@Override
	public void pre() throws IOException {
		this.pl = new Position[this.octx.width * this.octx.height];
		for(int ix=0; ix<this.octx.width; ++ix) {
			for(int iy=0; iy<this.octx.height; ++iy) {
				int si = iy*this.octx.width + ix;
				this.pl[si] = new Position(ix, iy, this.in_files.length);
			}
		}
	}

	@Override
	public void combine() throws IOException {
		int[] argbArray = null;
		for(int fx=0; fx<this.in_files.length; ++fx) {
			try {
				BufferedImage in_image = ImageIO.read(this.in_files[fx]);
				int in_width = in_image.getWidth();
				int in_height = in_image.getHeight();
				if(argbArray == null)
					argbArray = new int[3*in_width*in_height];
				Raster raster = in_image.getData();
				raster.getPixels(0, 0, in_width, in_height, argbArray);
				for(int ix=0; ix<in_width; ++ix) {
					for(int iy=0; iy<in_height; ++iy) {
						final int po = iy*in_width + ix;
						final int pi = 3*po;
						final Position p = this.pl[po]; 
						p.pixelList[p.append++] = new Pixel(argbArray[pi], argbArray[pi+1], argbArray[pi+2], (short)fx);
					}
				}
				in_image.flush();
				System.out.println(this.in_files[fx]);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		for (int pi = 0; pi < this.pl.length; pi++) {
			Arrays.sort(this.pl[pi].pixelList, new SortByGray());
		}
	}

	@Override
	public int[] post(int i) throws IOException {
		if(i == 0) {
			int pixels[] = new int[this.octx.width * this.octx.height];
			for (int pi = 0; pi < pixels.length; pi++) {
				Pixel[] pl = this.pl[pi].pixelList;
				pixels[pi] = pl[pl.length / 2].argb;
			}
			return pixels;
		}
		return null;
	}

	@Override
	public String name(int i) {
		return "";
	}

	@Override
	public String toString() {
		return "Median []";
	}

}
