package slitscan;

public class Point implements Comparable<Point> {
	final Point next;
	public final int tx;
	public final int ty;
	public int sx;
	public int sy;
	public double sz;

	public Point(Point point, int tx, int ty) {
		super();
		this.next = point;
		this.tx = tx;
		this.ty = ty;
	}

	@Override
	public int compareTo(Point p) {
		if(this.sz > p.sz) return 1;
		if(this.sz < p.sz) return -1;
		return 0;
	}

	@Override
	public String toString() {
		return "Point [tx=" + this.tx + ", ty=" + this.ty + ", sx=" + this.sx + ", sy=" + this.sy + ", sz=" + this.sz + "]";
	}
}
