package slitscan;

public abstract class OrbitRoot {
	public ContextIn ictx;
	public ContextOut octx;
	public ExternalTracker tracker;
	
	public class ArgState {
		final boolean defined;
		final boolean percent;
		final double value;

		public ArgState(boolean defined, String arg, int default_value) {
			super();
			this.defined = defined;
			if(defined) {
				if(arg.endsWith("%")) {
					this.value = Double.parseDouble(arg.substring(0, arg.length() - 1));
					this.percent = true;
				}
				else {
					this.value = Double.parseDouble(arg);
					this.percent = false;
				}
			}
			else {
				this.value = default_value;
				this.percent = false;
			}
		}

		public int getInt(int range) {
			if(this.percent) {
				return (int)((double)this.value * (double)range / 100.0);
			}
			return (int)this.value;
		}
	}
	
	public void setTracker(ExternalTracker tracker) {
		this.tracker = tracker;
	}

	protected boolean checkArg(String[] args, int ax) {
		return args.length > ax && args[ax].length() > 0;
	}

	protected ArgState checkArgState(String[] args, int ax, int default_value) {
		if(ax >= args.length)
			return new ArgState(false, "", default_value);
		return new ArgState(args.length > ax && args[ax].length() > 0, args[ax], default_value);
	}

}
