package slitscan;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

public class ContextIn {
	public static final int IN_WIDTH_OUT_HIGHT = -1;

	public final int width;
	public final int height;
	public final int depth;

	public ContextIn(File[] in_files) {
		BufferedImage in_image = null;
		try {
			in_image = ImageIO.read(in_files[0]);
		} catch (IOException e) {
			e.printStackTrace();
		}
		if(in_image != null) {
			this.width = in_image.getWidth();
			this.height = in_image.getHeight();
			this.depth = in_files.length;
		}
		else {
			this.width = 0;
			this.height = 0;
			this.depth = 0;
		}
	}

	@Override
	public String toString() {
		return "ContextIn [width=" + this.width + ", height=" + this.height + ", depth=" + this.depth + "]";
	}
}

