package slitscan;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.imageio.ImageIO;

public class CombineScanner {
	public static void work(File[] in_files, ConCombine combiner, String range_label, String tracker_fn) {
		assert in_files != null && in_files.length > 0;
		try {
			long t0 = System.nanoTime();
			ContextIn ictx = new ContextIn(in_files);
			System.out.println("in      = " + ictx);
			ContextOut octx = combiner.buildContextOut(ictx);
			System.out.println("out     = " + octx);

			combiner.pre();
			long t1 = System.nanoTime();
			System.out.println("pre     = " + ((t1 - t0) / 1000000.0));

			combiner.combine();
			long t4 = System.nanoTime();
			System.out.println("combine = " + ((t4 - t1) / 1000000.0));

			write_pixels(combiner, 0, range_label, octx);
			write_pixels(combiner, 1, range_label, octx);
			write_pixels(combiner, 2, range_label, octx);

			long t5 = System.nanoTime();
			System.out.println("write   = " + ((t5 - t4) / 1000000.0));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void write_pixels(ConCombine combiner, int i, String range_label, ContextOut octx) throws IOException {
		int pixels[] = combiner.post(i);
		if (pixels != null) {
			BufferedImage out_iamge = new BufferedImage(octx.width, octx.height, BufferedImage.TYPE_INT_ARGB);
			out_iamge.setRGB(0, 0, octx.width, octx.height, pixels, 0, octx.width);
			SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
			String output_name = application.SL.out_path + "combine-" + combiner + combiner.name(i) + range_label + "-" + sdf.format(new Date()) + ".png";
			output_name = output_name.replace(" ", "");
			ImageIO.write(out_iamge, "png", new File(output_name));
			System.out.println("output  = " + output_name);
		}
	}

}
