package noise;

import static org.junit.Assert.*;

import java.util.Arrays;

import org.junit.Test;

public class ImprovedNoiseTest {

	private static final int HIST_SIZE = 25;
	private static final double STEP = 0.01;

	@Test
	public void testSigned() {
		ImprovedNoise noise = new ImprovedNoise();
		noise.seed(1512);
		double min = noise.noise(0, 0, 0.0);
		double max = min;
		double x = -1.0;
		while(x < 1.0) {
			double y = -1.0;
			while(y < 1.0) {
				double v = noise.noise(x, y, -0.5);
				if(v < min)
					min = v;
				if(v > max)
					max = v;
				y += STEP;
			}
			x += STEP;
		}
		System.out.println("testSigned " + min + " " + max);
        assertEquals(-0.5230239999999999, min, 0.0);
        assertEquals(0.8168563972739176, max, 0.0);
	}

	@Test
	public void testUnsigned() {
		ImprovedNoise noise = new ImprovedNoise();
		noise.seed(1512);
		double min = noise.noise(0, 0, 0.0);
		double max = min;
		double x = 0.0;
		while (x < 1.0) {
			double y = 0.0;
			while (y < 1.0) {
				double z = 0.0;
				while (z < 1.0) {
					double v = noise.noise(x, y, z);
					if (v < min)
						min = v;
					if (v > max)
						max = v;
					z += STEP;
				}
				y += STEP;
			}
			x += STEP;
		}
		System.out.println("testUnsigned " + min + " " + max);
		assertEquals(-0.6234952154920312, min, 0.0);
		assertEquals(0.6822987627996948, max, 0.0);
	}

	@Test
	public void testHistogram() {
		ImprovedNoise noise = new ImprovedNoise();
		noise.seed(1512);
		int[] h = new int[HIST_SIZE];
		double x = 0.0;
		while (x < 1.0) {
			double y = 0.0;
			while (y < 1.0) {
				double z = 0.0;
				while (z < 1.0) {
					double v = noise.noise(x, y, z);
					int vi = (int)(HIST_SIZE * (v+1.0) / 2.0);
					assertTrue("vi >= 0", vi >= 0);
					assertTrue("vi < HIST_SIZE", vi < HIST_SIZE);
					h[vi] += 1;
					z += STEP;
				}
				y += STEP;
			}
			x += STEP;
		}
		System.out.println("testHistogram " + Arrays.toString(h));
	}

}
