package filesort;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;

public class Input {
	/**
	 * Search for files none recursively.
	 * 
	 * @param directory Starting folder.
	 * @param startswith File names are accepted if they start with this pattern.
	 * @param endswith File names are accepted if they end with this pattern.
	 * @return A list of file names with the specified pattern.
	 */
	public static File[] listFiles(File directory, final String startswith, final String endswith) {
		assert startswith != null && startswith.length() > 0;
		assert endswith != null && endswith.length() > 0;
		// Are there some "startswith*.endswith" files?
		File[] entries = directory.listFiles(new FilenameFilter() {
			@Override
			public boolean accept(File entry, String name) {
				return name.startsWith(startswith) && name.endsWith(endswith);
			}
		});
		Arrays.sort(entries);
		return entries;
	}

}
