package application;
import java.io.File;
import java.util.Arrays;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import filesort.Input;

public class Interpolate {

	private static final String PATH = "path";
	private static final String P = "p";
	private static final String STARTSWITH = "startswith";
	private static final String S = "s";
	private static final String ENDSWITH = "endswith";
	private static final String E = "e";

	private static boolean accepted = false;
	
	public static void main(String[] args) {
		System.out.println(Arrays.toString(args).replace(", ", " ")); 
		Options options = new Options();
		options.addOption(P, PATH, true, "path to image files");
		options.addOption(S, STARTSWITH, true, "file name stats with pattern");
		options.addOption(E, ENDSWITH, true, "file name ends with pattern");

		String path = "";
		String startswith = "";
		String endswith = ".png";
		CommandLineParser parser = new DefaultParser();
		CommandLine line;
		try {
			line = parser.parse(options, args);
			if (line.hasOption(PATH)) {
				path = line.getOptionValue(PATH);
			}
			if (line.hasOption(STARTSWITH)) {
				startswith = line.getOptionValue(STARTSWITH);
			}
			if (line.hasOption(ENDSWITH)) {
				endswith = line.getOptionValue(ENDSWITH);
			}
		} catch (ParseException ex) {
			ex.printStackTrace();
		}
		
		File[] in_files = null;
		if (path.length() > 0 && startswith.length() > 0) {
			if (!path.endsWith("/"))
				path += "/";
			in_files = Input.listFiles(new File(path), startswith, endswith);
			int in_files_len = in_files.length - 1;
			for(int i=0; i<in_files_len; ++i) {
				String ii =	String.format("%04d", i);
				System.out.println("convert -limit memory 2000MiB " + in_files[i] + " " + in_files[i+1] + " -morph 8 blend-" + ii + ".png");
			}
			accepted = true;
		}
		if(in_files != null && in_files.length > 0) {
		}
		else {
			System.out.println("no input images");
		}
		
		if (!accepted) {
			HelpFormatter formatter = new HelpFormatter();
			formatter.printHelp(Interpolate.class.getName(), options);
		}
	}

}
