#!/bin/bash

JARFILE=SL-0.1.0.jar
IMGPATH=split
STARTSWITH=clip_
ENDSWITH=.png
MEMSIZE="-Xmx16g"

####################### slitscan.func
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.func.PerlinNoiseFunc \
                              --p1 1512,3.55,2.0,0

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.SinCosFunc \
                              --p1 0.5,0.5,-0.25

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.SinFunc \
                              --p1 0.25,0.33,0.5

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.SinCosFunc \
                              --p1 0.25,0.33,0.5

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.SinCosFunc \
                              --p1 0.1,0.9,0.5

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.SinCosFunc \
                              --p1 0.5,0.5,0.1

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.NoiseFunc \
                              --p1 1512

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.CenterFunc \
                              --p1 1512,0.01

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.CenterFunc \
                              --p1 1512,0.1

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel1 slitscan.func.CenterFunc \
                              --p1 1512,0.6

##################### slitscan.slit
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FeigenbaumHorizontal

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.SquareRandomArea \
                              --p1 10

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.SquareRandomArea \
                              --p1 25

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.CircularDDA \
                              --p1 260,480,250
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.CircularDDA \
                              --p1 260,480,235

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearDDA \
                              --p1 540,960,0,0
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearDDA \
                              --p1 0,0,540,960

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedVerticalSlit
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedHorizontalSlit
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.Fixed2HorizontalSlit

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedHorizontalWideSlit \
                              --p1 ,3
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedVerticalWideSlit \
                              --p1 ,5

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearVerticalSlit \
                              --p1 1
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearHorizontalSlit \
                              --p1 0

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.NonLinearHorizontalSlit
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.NonLinearHorizontalSlit \
                              --p1 log1p
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.NonLinearHorizontalSlit \
                              --p1 sqrt
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.NonLinearHorizontalSlit \
                              --p1 sqr

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedHorizontalRasterSlit \
                              --p1 ,25

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedVerticalWideCenterSlit \
                              --p1 ,25

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedVerticalStripes \
                              --p1 0
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedVerticalStripes \
                              --p1 1

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedHorizontalStripes
java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.FixedHorizontalStripes \
                              --p1 1

java -Xmx6G -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearPixel \
                              --p1 0
java -Xmx6G -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearPixel \
                              --p1 1
java -Xmx6G -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearPixel \
                              --p1 2
java -Xmx6G -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH  --endswith $ENDSWITH \
                              --kernel1 slitscan.slit.LinearPixel \
                              --p1 3

###################### slitscan.combine
ava $MEMSIZE -jar $JARFILE --path $IMGPATH \
                             --startswith $STARTSWITH  --endswith $ENDSWITH \
                             --range *,*,1 \
                             --p1 5,2,250 \
                             --kernel1 slitscan.concombine.Flash

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                             --startswith $STARTSWITH  --endswith $ENDSWITH \
                             --range *,*,200 \
                             --kernel1 slitscan.concombine.MMA


java -Xmx16g -jar $JARFILE --path $IMGPATH \
                             --startswith $STARTSWITH  --endswith $ENDSWITH \
                             --range *,*,10 \
                             --kernel1 slitscan.combine.Median

