# Slit-scan photography
[[_TOC_]]

## Simple slit-scan photography

* Record a short video.
  * If possible record at high frame rates
  * If you use footage as source disassemble the movie frame by frame to generate the a lot of photos. Its good to have some thousands single frames.
* Or take lots of photos over a long time.
* Then cut from every photo a small strip, maybe 1 pixel small. Only one strip per photo. And arrange the these stripes to build one new image.

## An other way to think about slit-scan photography

Your footage is formed like an 3D quarter. On the front side of this quarter the first image of your series can be seen. All the photos or frames are can be thougt as X/Y planes inside this quarter. In Z direction all the images are sequentially stacked. You can call the Z direction the time axis.

Its now possible to cut this quarter in an arbitrary ways. Look at the cutting face. This intersecting plane is your new image.

![](/doc/simple-image-stack.jpg)

![](/doc/orbit-FixedVerticalWideCenterSlit.jpg)


## Software used for simple slit-scan photography

* FFmpeg to split footage to single images.
* SL-0.1.0.jar A OpenJDK program to cut small stripes out of images and arrange them to a new image.
* (optional) GNU Wget to capture images from web cams.
* (optional) Fswebcam a tiny and flexible webcam command-line program for capturing
images from a V4L1/V4L2 device. 

## Original footage
You need a lot of image files having sortable file names.

All image file names should have an common prefix.

```bash
find split | sort
  split/clip_00001.png
  split/clip_00002.png
  split/clip_00003.png
  ...
  split/clip_01500.png
```

All Images must be identical in width and height.

## How to capture or pre-process the original footage
One way is splitting a video file into lots of single frames.

`moviesplit`

```bash
#!/bin/bash
mkdir split
cd split
ffmpeg -i ../$1 clip_%05d.png
```

Or capture images from a public WEB-cam.

`public-web-cam.sh`

```bash
#!/bin/bash
mkdir split
for i in `seq 3000`
do
filenumber=$(printf '%05d\n' $i)
wget -O split/clip_$filenumber.jpg --tries=2 https://webcam.your-favorit-cam.com/current.jpg
sleep 60
done
```

Or capture images from a V4L1/V4L2 compatible USB camera.

`local-cam.sh`

```bash
#!/bin/bash
mkdir split
VIDEODEVICE=video1
#uvcdynctrl --device $VIDEODEVICE --set "Power Line Frequency" 1
#uvcdynctrl --device $VIDEODEVICE --set  Sharpness 7
#uvcdynctrl --device $VIDEODEVICE --set "Focus, Absolute" 129
#uvcdynctrl --device $VIDEODEVICE --set "Brightness" 0
#sleep 1
for i in `seq 10`
do
filenumber=$(printf "%05d" $i)
fswebcam -d /dev/$VIDEODEVICE -r 3264x2448 split/clip_$filenumber.jpg
sleep 5
done
```

## Slit-scan as post process
Prepare a shell script. You can use sl.sh as a template.

```bash
JARFILE=~/workspace-java/slitscan/SL-0.1.0.jar
IMGPATH=split
STARTSWITH=clip_
ENDSWITH=.png
MEMSIZE="-Xmx16g"

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                              --startswith $STARTSWITH --endswith $ENDSWITH \
                              --kernel slitscan.slit.CircularDDA \
                              --p1 50%,50%,85%

java $MEMSIZE -jar $JARFILE --path $IMGPATH \
                             --startswith $STARTSWITH  --endswith $ENDSWITH \
                             --range *,*,20 \
                             --kernel slitscan.concombine.MMA
```

Start this script. It will read your captured image sequence file by file from your storage device.


## Memory management and performance
SL uses image files as input. Formats with lossless compression are best. The frames extracted from 1 minute of film material can occupy 10 GB of files. All these files are read each time SL is started. An sl.sh script can contain multiple calls. This results in large amounts of data being transferred from the storage device to the CPU.

These strategies are helpful:
* The image files should be stored on an SSD drive.
* The size of the heap of the JVM should not be set too large. Free RAM is used by the Linux kernel as cache for files.
* A heap that is too small will cause the garbage collector to require too much computing time. Increase `-Xmx`
* If the heap is not large enough, an OutOfMemory exception will be thrown.  Increase `-Xmx`
* `slitscan.combine.Median` needs a huge amount Heap space. Restrict how many files are processed. `--range *,*,10` only reads every tenth file.


## SL documnetation
| option | description |
| ------ | ----------- |
| -p, --path <arg>        | path to image files |
| -r, --range <arg>       | process only a limited range of input files: from,count,modulo |
| -s, --startswith <arg>  | file name stats with pattern |
| -e, --endswith <arg>    | file name ends with pattern |
| -k, --kernel1 <arg>     | this class used as main kernel |
| -1, --p1 <arg>          | parameters used for initializing the main kernel |
| -k, --kernel2 <arg>     | this class used as second kernel |
| -2, --p2 <arg>          | parameters used for initializing the second kernel |
| -m, --mix <arg>         | factor for mixing both kernels |
| -o, --out <arg>         | path to output files. default is /tmp/sl/ |

### Kernel algorithm and parametrization
The `--kernel1` parameter is used to select the algorithm. The `--p1` parameter can be used to pass numerical parameters separated by commas to the selected algorithm. If the `--p1` parameter is missing, SL uses default values.

Circular Slit, center of the circle at pixel x=256, y=480, radius is 250 pixel.
```
--kernel1 slitscan.slit.CircularDDA --p1 260,480,250
```

All values are given in percentages here.
The center of the circle is in the middle of the input image.
The diameter is 95% of the shortest side.
```
--kernel slitscan.slit.CircularDDA --p1 50%,50%,95%
```

Output maximum, minimum and average pixel brightness. But only process every 200th input image.
The first value and the second value is written as `*`. This is an example where SL inserts default values.
```
--range *,*,200 --kernel slitscan.concombine.MMA
```

### Combining two kernels
In some cases, the generated slit-scan image looks too trivial. This can be counteracted by combining two different kernels. The `--mix` parameter specifies how strongly the second kernel influences the result.

This combination method is still very experimental. It can only be used for kernels from packages `slitscan.slit` and `slitscan.func`.

```
--mix 0.5 --kernel1 slitscan.slit.CircularDDA --p1 50%,50%,95% --kernel2 slitscan.slit.LinearHorizontalSlit --p2 1
```


### Typical Slit-Scan post processing
#### slitscan.slit.CircularDDA
Using a circle line to cut the input images.
```
--kernel1 slitscan.slit.CircularDDA --p1 <x0>,<y0>,<r>
```

| parameter | description |
| ------ | ----------- |
|  x0 | x coordinate center of the circle |
|  y0 | y coordinate center of the circle |
|  r  | radius of the circle |

#### slitscan.slit.FeigenbaumHorizontal
Using a Feigenbaum fractal to cut the input images.

```
--kernel1 slitscan.slit.FeigenbaumHorizontal
```
no parameter

#### slitscan.slit.Fixed2HorizontalSlit
Using a horizontal line to cut the input images.

```
--kernel1 slitscan.slit.Fixed2HorizontalSlit --p1 <where>
```

| parameter | description |
| ------ | ----------- |
| where | y coordinate of the horizontal slit |

#### slitscan.slit.Fixed2VerticalSlit
Using a vertical line to cut the input images.
The slit is at a constant x position.
The size oft the image is compressed.

```
--kernel1 slitscan.slit.Fixed2VerticalSlit --p1 <where>
```

| parameter | description |
| ------ | ----------- |
| where | x coordinate of the vertical slit |

#### slitscan.slit.FixedHorizontalRasterSlit

```
--kernel1 slitscan.slit.FixedHorizontalRasterSlit --p1 <where>,<swidth>>
```

| parameter | description |
| ------ | ----------- |
| where | y coordinate of the horizontal slit |
| swidth | width of the stripes |

#### slitscan.slit.FixedHorizontalSlit

```
--kernel1 slitscan.slit.FixedHorizontalSlit --p1 <where>
```

| parameter | description |
| ------ | ----------- |
| where | y coordinate of the horizontal slit |

#### slitscan.slit.FixedHorizontalStripes

```
--kernel1 slitscan.slit.FixedHorizontalStripes --p1 <forward>
```

| parameter | description |
| ------ | ----------- |
| forward | `0` or `1` |

#### slitscan.slit.FixedHorizontalWideSlit
Generates images that are stretched in one dimension. This algorithm can be used when the source material has only a few frames.

```
--kernel1 slitscan.slit.FixedHorizontalWideSlit --p1 <where>,<swidth>>
```
Generates images that are stretched in one dimension. This algorithm can be used when the source material has only a few frames.

| parameter | description |
| ------ | ----------- |
| where | y coordinate of the horizontal slit |
| swidth | width of the stripes |

#### slitscan.slit.FixedVerticalSlit
Using a vertical line to cut the input images.
The slit is at a constant x position.


```
--kernel1 slitscan.slit.FixedVerticalSlit --p1 <where>
```
Using a vertical line to cut the input images.

| parameter | description |
| ------ | ----------- |
| where | y coordinate of the horizontal slit |

#### slitscan.slit.FixedVerticalStripes

```
--kernel1 slitscan.slit.FixedVerticalStripes --p1 <forward>
```

| parameter | description |
| ------ | ----------- |
| forward | `0` or `1` |

#### slitscan.slit.FixedVerticalWideCenterSlit
Using a vertical line to cut the input images.
Generates images that are stretched in one dimension. This algorithm can be used when the source material has only a few frames.

```
--kernel1 slitscan.slit.FixedVerticalWideCenterSlit --p1 <where>,<swidth>
```

| parameter | description |
| ------ | ----------- |
| where | x coordinate of the vertical slit |
| swidth | width of the stripes |

#### slitscan.slit.FixedVerticalWideSlit
Using a vertical line to cut the input images.
Generates images that are stretched in one dimension. This algorithm can be used when the source material has only a few frames.

```
--kernel1 slitscan.slit.FixedVerticalWideSlit --p1 <where>,<swidth>
```

| parameter | description |
| ------ | ----------- |
| where | x coordinate of the vertical slit |
| swidth | width of the stripes |

#### slitscan.slit.LinearDDA

```
--kernel1 slitscan.slit.LinearDDA --p1 <x0>,<y0>,<x1>,<y1>
```
Using a line, defined by two points, to cut the input images.

| parameter | description |
| ------ | ----------- |
| x0 | x coordinate of the start point |
| y0 | y coordinate of the start point |
| x1 | x coordinate of the end point |
| y1 | y coordinate of the end point |

#### slitscan.slit.LinearHorizontalSlit
Using a horizontal line to cut the input images.
The slit is moving from top to down or in opposite direction.

```
--kernel1 slitscan.slit.LinearHorizontalSlit --p1 <top>
```

| parameter | description |
| ------ | ----------- |
| top | `0` or `1` |

#### slitscan.slit.LinearPixel
Calculating the next slit position at every pixel.

```
--kernel1 slitscan.slit.LinearPixel --p1 <dir>
```

| parameter | description |
| ------ | ----------- |
| dir | direction `0`, `1`, `2` or `3` |

#### slitscan.slit.LinearVerticalSlit
Using a vertical line to cut the input images.
The slit is moving from left to right or in opposite direction.

```
--kernel1 slitscan.slit.LinearVerticalSlit --p1 <left>
```

| parameter | description |
| ------ | ----------- |
| left | `0` or `1` |

#### slitscan.slit.NonLinearHorizontalSlit
Using mathematical functions to move the slit.

```
--kernel1 slitscan.slit.NonLinearHorizontalSlit --p1 <func>,<a>,<b>
```

| parameter | description |
| ------ | ----------- |
| func | `sin`, `log1p`, `sqrt`, `sqr`, `pow` or `smoothstep` |
| a | only used for `smoothstep` |
| b | only used for `smoothstep` |

#### slitscan.slit.SquareRandomArea
Selects random tiles.

```
--kernel1 slitscan.slit.SquareRandomArea --p1 <size>
```

| parameter | description |
| ------ | ----------- |
| size | raster size |


### Using mathematical functions for post processing
#### slitscan.func.CenterFunc
Selects random pixels. The center is affected by randomness more than the periphery.

```
--kernel1 slitscan.func.CenterFunc --p1 <seed>
```

| parameter | description |
| ------ | ----------- |
| seed | seed for the random number generator |


#### slitscan.func.PerlinNoiseFunc
Using a Perlin noise function to select pixels.

```
--kernel1 slitscan.func.PerlinNoiseFunc --p1 <xFrequency>,<yFrequency>,<phase>,<seed>
```

| parameter | description |
| ------ | ----------- |
| xFrequency | Density in the x direction |
| yFrequency | Density in the y direction |
| phase | additional coordinate where to calculate the Perlin noise |
| seed | seed for the random number generator |

#### slitscan.func.SinCosFunc
Using a sine wave and a cosine wave function to select pixels.

```
--kernel1 slitscan.func.SinCosFunc --p1 <xFrequency>,<yFrequency>,<phase>
```

| parameter | description |
| ------ | ----------- |
| xFrequency | Density in the x direction |
| yFrequency | Density in the y direction |
| phase | phase shift |

#### slitscan.func.SinFunc
Using a sine wave function to select pixels.

```
--kernel1 slitscan.func.SinFunc --p1 <frequency>,<mx>,<my>
```

| parameter | description |
| ------ | ----------- |
| frequency | Density in the radial direction |
|  mx | x coordinate center of the effect |
|  my | y coordinate center of the effect |


### None slit-scan post processing
#### slitscan.combine.Median
Median pixel, by brightness of pixels. This needs a lot of heap space. Please reduce the number of frames to process.

```
--kernel1 slitscan.combine.Median
```

no parameter

#### slitscan.concombine.Flash
A long exposure brightened by one or more short flashes.

```
--kernel1 slitscan.concombine.Flash --p1 <nstops>,<width>,<weight>
```

| parameter | description |
| ------ | ----------- |
| nstops | number of flashs fiering |
| width | duration of a flash in frames |
| weight | intensity of a single flash |

#### slitscan.concombine.MMA
Calculates per pixel the minimum, maximum and average value.

```
--kernel1 slitscan.concombine.MMA
```

no parameter
