/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import java.util.Random;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class SquareRandomArea
extends OrbitRoot
implements Orbit {
    final int size;
    int nx;
    int ny;
    int[] nn;
    Random ri = new Random(1512L);

    public SquareRandomArea(File[] in_files, String[] args) {
        this.size = this.checkArg(args, 0) ? Integer.parseInt(args[0]) : 10;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.nx = ictx.depth / this.size;
        this.ny = ictx.width / this.size;
        this.nn = new int[(this.nx + 1) * (this.ny + 1) * 10];
        int i = 0;
        while (i < this.nn.length) {
            this.nn[i] = this.ri.nextInt(ictx.depth);
            ++i;
        }
        this.octx = new ContextOut(ictx.depth, ictx.width);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.ty;
        int tile_x = p.ty / this.size;
        int tile_y = p.tx / this.size;
        p.sz = this.nn[tile_x * this.ny + tile_y];
        p.sy = (int)((double)p.tx / (double)this.octx.width * (double)this.ictx.height);
    }

    public String toString() {
        return "SquareRandomArea [size=" + this.size + "]";
    }
}

