/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class LinearVerticalSlit
extends OrbitRoot
implements Orbit {
    final boolean left;

    public LinearVerticalSlit(File[] in_files, String[] args) {
        this.left = this.checkArg(args, 0) ? args[0].equals("0") : true;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.octx = new ContextOut(ictx.width, ictx.height);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.tx;
        p.sy = p.ty;
        p.sz = this.left ? (double)p.tx / (double)this.octx.width * (double)this.ictx.depth : (1.0 - (double)p.tx / (double)this.octx.width) * (double)this.ictx.depth;
    }

    public String toString() {
        return "LinearVerticalSlit [left=" + this.left + "]";
    }
}

