/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class LinearPixel
extends OrbitRoot
implements Orbit {
    final int dir;
    double num_pixels = 0.0;

    public LinearPixel(File[] in_files, String[] args) {
        this.dir = this.checkArg(args, 0) ? Math.abs(Integer.parseInt(args[0])) % 4 : 0;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.octx = new ContextOut(ictx.width, this.ictx.height);
        this.num_pixels = this.ictx.width * this.ictx.height;
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.tx;
        p.sy = p.ty;
        double ratio = 0.0;
        switch (this.dir) {
            case 0: {
                ratio = (double)(p.ty * this.ictx.width + p.tx) / this.num_pixels;
                break;
            }
            case 1: {
                ratio = (double)(p.tx * this.ictx.height + p.ty) / this.num_pixels;
                break;
            }
            case 2: {
                ratio = 1.0 - (double)(p.ty * this.ictx.width + p.tx) / this.num_pixels;
                break;
            }
            case 3: {
                ratio = 1.0 - (double)(p.tx * this.ictx.height + p.ty) / this.num_pixels;
            }
        }
        p.sz = ratio * (double)this.ictx.depth;
    }

    public String toString() {
        return "LinearPixel [dir=" + this.dir + "]";
    }
}

