/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class LinearHorizontalSlit
extends OrbitRoot
implements Orbit {
    final boolean top;

    public LinearHorizontalSlit(File[] in_files, String[] args) {
        this.top = this.checkArg(args, 0) ? args[0].equals("0") : true;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.octx = new ContextOut(ictx.depth, ictx.width);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.ty;
        p.sz = p.tx;
        p.sy = this.top ? (int)((double)p.tx / (double)this.octx.width * (double)this.ictx.height) : (int)((1.0 - (double)p.tx / (double)this.octx.width) * (double)this.ictx.height);
    }

    public String toString() {
        return "LinearHorizontalSlit [top=" + this.top + "]";
    }
}

