/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import java.util.Vector;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class LinearDDA
extends OrbitRoot
implements Orbit {
    int x0;
    int y0;
    int x1;
    int y1;
    final OrbitRoot.ArgState arg_x0;
    final OrbitRoot.ArgState arg_y0;
    final OrbitRoot.ArgState arg_x1;
    final OrbitRoot.ArgState arg_y1;
    boolean ascending;
    Vector<Integer> vx;
    Vector<Integer> vy;
    int[] tx;
    int[] ty;

    public LinearDDA(File[] in_files, String[] args) {
        this.arg_x0 = this.checkArgState(args, 0, -1);
        this.arg_y0 = this.checkArgState(args, 1, -1);
        this.arg_x1 = this.checkArgState(args, 2, -1);
        this.arg_y1 = this.checkArgState(args, 3, -1);
    }

    private void append(int x, int y) {
        this.vx.add(x);
        this.vy.add(y);
    }

    private void ddaLine(int lx0, int ly0, int lx1, int ly1) {
        float dx = lx1 - lx0;
        float dy = ly1 - ly0;
        float step = Math.abs(dx) >= Math.abs(dy) ? Math.abs(dx) : Math.abs(dy);
        dx /= step;
        dy /= step;
        float x = this.x0;
        float y = this.y0;
        int i = 0;
        while ((float)i <= step) {
            this.append(Math.round(x), Math.round(y));
            x += dx;
            y += dy;
            ++i;
        }
    }

    private void buildTable() {
        this.vx = new Vector();
        this.vy = new Vector();
        this.ddaLine(this.x0, this.y0, this.x1, this.y1);
        this.tx = new int[this.vx.size()];
        this.ty = new int[this.vy.size()];
        int i = 0;
        while (i < this.tx.length) {
            this.tx[i] = this.vx.get(i);
            this.ty[i] = this.vy.get(i);
            ++i;
        }
        this.vx = null;
        this.vy = null;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.x0 = this.arg_x0.getInt(ictx.width);
        this.y0 = this.arg_y0.getInt(ictx.height);
        this.x1 = this.arg_x1.getInt(ictx.width);
        this.y1 = this.arg_y1.getInt(ictx.height);
        if (this.x0 < 0) {
            this.x0 = 0;
        }
        if (this.y0 < 0) {
            this.y0 = 0;
        }
        if (this.x1 < 0) {
            this.x1 = ictx.width;
        }
        if (this.y1 < 0) {
            this.y1 = ictx.height;
        }
        this.ascending = this.x1 > this.x0 ^ this.y1 > this.y0;
        this.buildTable();
        this.octx = new ContextOut(ictx.depth, this.tx.length);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sy = this.ty[p.ty];
        p.sx = this.tx[p.ty];
        p.sz = this.ascending ? (double)p.tx / (double)this.octx.width * (double)this.ictx.depth : (double)this.ictx.depth - (double)p.tx / (double)this.octx.width * (double)this.ictx.depth;
    }

    public String toString() {
        return "LinearDDA [x0=" + this.x0 + ", y0=" + this.y0 + ", x1=" + this.x1 + ", y1=" + this.y1 + "]";
    }
}

