/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class HorizontalTrackerSlit
extends OrbitRoot
implements Orbit {
    final int smooth;
    final boolean normalized;

    public HorizontalTrackerSlit(File[] in_files, String[] args) {
        int n = this.smooth = this.checkArg(args, 0) ? Integer.parseInt(args[0]) : 0;
        this.normalized = this.checkArg(args, 1) ? !args[1].equals("0") : false;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.octx = new ContextOut(ictx.width, ictx.height);
        int so = 0;
        while (so < this.smooth) {
            this.tracker.doSmoothing();
            ++so;
        }
        if (this.normalized) {
            this.tracker.normalize();
        }
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.tx;
        p.sy = p.ty;
        p.sz = this.tracker.yNear((double)p.ty / (double)this.ictx.height);
        if (p.tx == 0) {
            System.out.println(p);
        }
    }

    public String toString() {
        return "HorizontalTrackerSlit [smooth=" + this.smooth + ", normalized=" + this.normalized + "]";
    }
}

