/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FixedVerticalStripes
extends OrbitRoot
implements Orbit {
    private final int listlen;
    private final double stripewidth;
    final boolean forward;

    public FixedVerticalStripes(File[] in_files, String[] args) throws IOException {
        this.listlen = in_files.length;
        BufferedImage in_image = ImageIO.read(in_files[0]);
        double s = (double)in_image.getWidth() / (double)this.listlen;
        this.stripewidth = s < 1.0 ? 1.0 : s;
        this.forward = this.checkArg(args, 0) ? args[0].equals("0") : true;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        this.octx = new ContextOut(ictx.width, ictx.height);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.tx;
        p.sy = p.ty;
        p.sz = (int)((double)p.tx / this.stripewidth);
        if (this.forward) {
            p.sz = (double)this.listlen - p.sz;
        }
        if (p.sz >= (double)this.listlen) {
            p.sz = this.listlen - 1;
        }
    }

    public String toString() {
        return "FixedVerticalStripes [stripewidth=" + this.stripewidth + ", forward=" + this.forward + "]";
    }
}

