/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class Fixed2VerticalSlit
extends OrbitRoot
implements Orbit {
    private int where = -1;

    public Fixed2VerticalSlit(File[] in_files, String[] args) {
        this.where = this.checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        if (this.where < 0) {
            this.where = ictx.width / 2;
        }
        this.octx = new ContextOut(ictx.depth / 2, 2 * ictx.height);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        if (p.ty % 2 != 0) {
            p.sx = this.where;
            p.sy = p.ty / 2;
            p.sz = 2 * p.tx;
        } else {
            p.sx = this.where;
            p.sy = p.ty / 2;
            p.sz = 2 * p.tx + 1;
        }
    }

    public String toString() {
        return "Fixed2VerticalSlit [where=" + this.where + "]";
    }
}

