/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class FeigenbaumHorizontal
extends OrbitRoot
implements Orbit {
    final int skip = 100;
    int[] lookup;

    static double step(double p, double a) {
        return a * p * (1.0 - p);
    }

    public FeigenbaumHorizontal(File[] in_files, String[] args) {
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.lookup = new int[ictx.depth * ictx.width];
        double delta_a = 1.0 / (double)ictx.depth;
        int ai = 0;
        while (ai < ictx.depth) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            double p = 0.3;
            int i = 0;
            while (i < 100) {
                p = FeigenbaumHorizontal.step(p, 3.0 + delta_a * (double)ai);
                ++i;
            }
            int li = ictx.width * ai;
            int j = 0;
            while (j < ictx.width) {
                if ((p = FeigenbaumHorizontal.step(p, 3.0 + delta_a * (double)ai)) < min) {
                    min = p;
                }
                if (p > max) {
                    max = p;
                }
                this.lookup[li++] = (int)(p * (double)ictx.depth);
                ++j;
            }
            ++ai;
        }
        this.ictx = ictx;
        this.octx = new ContextOut(ictx.depth, ictx.width);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sx = p.ty;
        p.sz = this.lookup[this.ictx.width * p.tx];
        p.sy = (int)((double)p.tx / (double)this.octx.width * (double)this.ictx.height);
    }

    public String toString() {
        return "FeigenbaumHorizontal []";
    }
}

