/*
 * Decompiled with CFR 0.152.
 */
package slitscan.slit;

import java.io.File;
import java.util.Vector;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.OrbitRoot;
import slitscan.Point;

public class CircularDDA
extends OrbitRoot
implements Orbit {
    private static final int SLICES = 8;
    final OrbitRoot.ArgState arg_x0;
    final OrbitRoot.ArgState arg_y0;
    final OrbitRoot.ArgState arg_r;
    int x0;
    int y0;
    int r;
    Vector<Integer> vx;
    Vector<Integer> vy;
    int[] tx;
    int[] ty;

    public CircularDDA(File[] in_files, String[] args) {
        this.arg_x0 = this.checkArgState(args, 0, -1);
        this.arg_y0 = this.checkArgState(args, 1, -1);
        this.arg_r = this.checkArgState(args, 2, -1);
    }

    private void append(int x, int y) {
        this.vx.add(x);
        this.vy.add(y);
    }

    private void ddaCircle(int lx0, int ly0, int lr) {
        int x = 0;
        int y = lr;
        double d = 1.25 - (double)lr;
        this.append(x, y);
        while (y > x) {
            if (d <= 0.0) {
                d += (double)(2 * x + 3);
                ++x;
            } else {
                d += (double)(2 * (x - y) + 5);
                ++x;
                --y;
            }
            this.append(x, y);
        }
    }

    private static boolean testDub(int[] tax, int[] tay, int j) {
        int i = j - 1;
        while (i >= 0) {
            if (tax[i] == tax[j] && tay[i] == tay[j]) {
                return true;
            }
            --i;
        }
        return false;
    }

    private void buildTable() {
        this.vx = new Vector();
        this.vy = new Vector();
        this.ddaCircle(this.x0, this.y0, this.r);
        int[] tax = new int[8 * this.vx.size()];
        int[] tay = new int[8 * this.vy.size()];
        int j = 0;
        int i = 0;
        while (i < this.vx.size()) {
            tax[j] = this.vx.get(i) + this.x0;
            tay[j] = this.vy.get(i) + this.y0;
            ++j;
            ++i;
        }
        i = this.vx.size() - 1;
        while (i >= 0) {
            tax[j] = this.vy.get(i) + this.x0;
            tay[j] = this.vx.get(i) + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < this.vx.size()) {
            tax[j] = this.vy.get(i) + this.x0;
            tay[j] = -this.vx.get(i).intValue() + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            ++i;
        }
        i = this.vx.size() - 1;
        while (i >= 0) {
            tax[j] = this.vx.get(i) + this.x0;
            tay[j] = -this.vy.get(i).intValue() + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < this.vx.size()) {
            tax[j] = -this.vx.get(i).intValue() + this.x0;
            tay[j] = -this.vy.get(i).intValue() + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            ++i;
        }
        i = this.vx.size() - 1;
        while (i >= 0) {
            tax[j] = -this.vy.get(i).intValue() + this.x0;
            tay[j] = -this.vx.get(i).intValue() + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            --i;
        }
        i = 0;
        while (i < this.vx.size()) {
            tax[j] = -this.vy.get(i).intValue() + this.x0;
            tay[j] = this.vx.get(i) + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            ++i;
        }
        i = this.vx.size() - 1;
        while (i >= 0) {
            tax[j] = -this.vx.get(i).intValue() + this.x0;
            tay[j] = this.vy.get(i) + this.y0;
            if (!CircularDDA.testDub(tax, tay, j)) {
                ++j;
            }
            --i;
        }
        int remove = tax.length - j;
        this.tx = new int[tax.length - remove];
        System.arraycopy(tax, 0, this.tx, 0, tax.length - remove);
        this.ty = new int[tay.length - remove];
        System.arraycopy(tay, 0, this.ty, 0, tay.length - remove);
        this.vx = null;
        this.vy = null;
    }

    @Override
    public ContextOut buildContextOut(ContextIn ictx) {
        this.ictx = ictx;
        int min = ictx.width;
        if (ictx.height < ictx.width) {
            min = ictx.height;
        }
        this.x0 = this.arg_x0.getInt(ictx.width);
        this.y0 = this.arg_y0.getInt(ictx.height);
        this.r = this.arg_r.getInt(min / 2);
        if (this.x0 < 0) {
            this.x0 = ictx.width / 2;
        }
        if (this.y0 < 0) {
            this.y0 = ictx.height / 2;
        }
        if (this.r < 0) {
            this.r = min * 2 / 6;
        }
        this.buildTable();
        this.octx = new ContextOut(ictx.depth, this.tx.length);
        return this.octx;
    }

    @Override
    public void f(Point p) {
        p.sy = this.ty[p.ty];
        p.sx = this.tx[p.ty];
        p.sz = (double)p.tx / (double)this.octx.width * (double)this.ictx.depth;
    }

    public String toString() {
        return "CircularDDA [x0=" + this.x0 + ", y0=" + this.y0 + ", r=" + this.r + "]";
    }
}

