/*
 * Decompiled with CFR 0.152.
 */
package slitscan.func;

import java.io.File;
import slitscan.Orbit;
import slitscan.func.Func;

public class SinFunc
extends Func
implements Orbit {
    private final double frequency;
    private final double mx;
    private final double my;

    public SinFunc(File[] in_files, String[] args) {
        this.frequency = this.checkArg(args, 0) ? Double.parseDouble(args[0]) : 1.0;
        this.mx = this.checkArg(args, 1) ? Double.parseDouble(args[1]) : 0.0;
        this.my = this.checkArg(args, 2) ? Double.parseDouble(args[2]) : 0.0;
    }

    @Override
    public double g(double x, double y) {
        assert (x >= 0.0);
        assert (x <= 1.0);
        assert (y >= 0.0);
        assert (y <= 1.0);
        double xc = x - this.mx;
        double yc = y - this.my;
        double rad = Math.PI * 2 * Math.sqrt(xc * xc + yc * yc);
        return 0.5 + 0.5 * Math.sin(this.frequency * rad);
    }

    public String toString() {
        return "SinFunc [frequency=" + this.frequency + ", mx=" + this.mx + ", my=" + this.my + "]";
    }
}

