/*
 * Decompiled with CFR 0.152.
 */
package slitscan.func;

import java.io.File;
import slitscan.Orbit;
import slitscan.func.Func;

public class SinCosFunc
extends Func
implements Orbit {
    private final double xFrequency;
    private final double yFrequency;
    private double phase;

    public SinCosFunc(File[] in_files, String[] args) {
        this.xFrequency = this.checkArg(args, 0) ? Double.parseDouble(args[0]) : 1.0;
        this.yFrequency = this.checkArg(args, 1) ? Double.parseDouble(args[1]) : 1.0;
        this.phase = this.checkArg(args, 2) ? Double.parseDouble(args[2]) : 0.0;
    }

    @Override
    public double g(double x, double y) {
        return 0.5 + 0.25 * (Math.sin(Math.PI * 2 * (this.xFrequency * x + this.phase)) + Math.cos(Math.PI * 2 * (this.yFrequency * y + this.phase)));
    }

    public String toString() {
        return "SinCosFunc [xFrequency=" + this.xFrequency + ", yFrequency=" + this.yFrequency + ", phase=" + this.phase + "]";
    }
}

