/*
 * Decompiled with CFR 0.152.
 */
package slitscan.func;

import java.io.File;
import noise.ImprovedNoise;
import slitscan.Orbit;
import slitscan.func.Func;

public class PerlinNoiseFunc
extends Func
implements Orbit {
    private static final double STEP = 0.01;
    static final double EPSILON = 1.0E-4;
    private final ImprovedNoise noise;
    private final double xFrequency;
    private final double yFrequency;
    private final double phase;
    private final long seed;
    private double min = 0.0;
    private double max = 1.0;
    private double range;

    public PerlinNoiseFunc(File[] in_files, String[] args) {
        this.seed = this.checkArg(args, 0) ? Long.parseLong(args[0]) : 1512L;
        this.xFrequency = this.checkArg(args, 1) ? Double.parseDouble(args[1]) : 1.0;
        this.yFrequency = this.checkArg(args, 2) ? Double.parseDouble(args[2]) : 1.0;
        this.phase = this.checkArg(args, 3) ? Double.parseDouble(args[3]) : 0.0;
        this.noise = new ImprovedNoise();
        this.noise.seed(this.seed);
        this.max = this.min = this.noise.noise(0.0, 0.0, this.phase);
        double x = 0.0;
        while (x < 1.0) {
            double y = 0.0;
            while (y < 1.0) {
                double v = this.noise.noise(this.xFrequency * x, this.yFrequency * y, this.phase);
                if (v < this.min) {
                    this.min = v;
                }
                if (v > this.max) {
                    this.max = v;
                }
                y += 0.01;
            }
            x += 0.01;
        }
        this.range = this.max - this.min;
        assert (this.range > 0.0);
    }

    public double g_raw(double x, double y) {
        double v = this.noise.noise(this.xFrequency * x, this.yFrequency * y, this.phase);
        return (v - this.min) / this.range;
    }

    @Override
    public double g(double x, double y) {
        double v = this.g_raw(x, y);
        if (v < 0.0) {
            return 0.0;
        }
        if (v >= 1.0) {
            return 0.9999;
        }
        return v;
    }

    public String toString() {
        return "PerlinNoiseFunc[xFrequency=" + this.xFrequency + ",yFrequency=" + this.yFrequency + ",phase=" + this.phase + ",seed=" + this.seed + "]";
    }
}

