/*
 * Decompiled with CFR 0.152.
 */
package slitscan.func;

import java.io.File;
import java.util.Random;
import slitscan.Orbit;
import slitscan.func.Func;

public class CenterFunc
extends Func
implements Orbit {
    static final double EPSILON = 1.0E-4;
    private final long seed;
    private double scale;
    private final Random r;

    public CenterFunc(File[] in_files, String[] args) {
        this.seed = this.checkArg(args, 0) ? Long.parseLong(args[0]) : 1512L;
        this.scale = this.checkArg(args, 1) ? Double.parseDouble(args[1]) : 0.1;
        this.r = new Random(this.seed);
    }

    @Override
    public double g(double x, double y) {
        double rad = 2.0 * Math.hypot(x - 0.5, y - 0.5);
        double v = rad + this.scale * (this.r.nextDouble() - 0.5);
        if (v < 0.0) {
            return 0.0;
        }
        if (v >= 1.0) {
            return 0.9999;
        }
        return v;
    }

    public String toString() {
        return "CenterFunc [seed=" + this.seed + ", scale=" + this.scale + "]";
    }
}

