/*
 * Decompiled with CFR 0.152.
 */
package slitscan.concombine;

import java.util.concurrent.CountDownLatch;

class TileStopsCombiner
extends Thread {
    private final int[] argbArray;
    private double weight = 1.0;
    private final double[] r_sum;
    private final double[] g_sum;
    private final double[] b_sum;
    private final int in_width;
    private final int in_height;
    private final int start_x;
    private final int len_x;
    private final CountDownLatch scanning;

    public TileStopsCombiner(int in_width, int in_height, int sx, int lx, CountDownLatch scanning, int[] argbArray, double weight, double[] r_sum, double[] g_sum, double[] b_sum) {
        this.in_width = in_width;
        this.in_height = in_height;
        this.start_x = sx;
        this.len_x = lx;
        this.scanning = scanning;
        this.argbArray = argbArray;
        this.weight = weight;
        this.r_sum = r_sum;
        this.g_sum = g_sum;
        this.b_sum = b_sum;
    }

    @Override
    public void run() {
        try {
            int ix = 0;
            while (ix < this.len_x) {
                int iy = 0;
                while (iy < this.in_height) {
                    int po = iy * this.in_width + ix + this.start_x;
                    int pi = 3 * po;
                    int n = po;
                    this.r_sum[n] = this.r_sum[n] + this.weight * (double)this.argbArray[pi];
                    int n2 = po;
                    this.g_sum[n2] = this.g_sum[n2] + this.weight * (double)this.argbArray[pi + 1];
                    int n3 = po;
                    this.b_sum[n3] = this.b_sum[n3] + this.weight * (double)this.argbArray[pi + 2];
                    ++iy;
                }
                ++ix;
            }
        }
        finally {
            this.scanning.countDown();
        }
    }

    @Override
    public String toString() {
        return "TileStopsCombiner [weight=" + this.weight + ", in_width=" + this.in_width + ", in_height=" + this.in_height + ", start_x=" + this.start_x + ", len_x=" + this.len_x + ", scanning=" + String.valueOf(this.scanning) + "]";
    }
}

