/*
 * Decompiled with CFR 0.152.
 */
package slitscan.concombine;

import java.util.concurrent.CountDownLatch;

class TileMMACombiner
extends Thread {
    private final int[] argbArray;
    private final int[] max_pixel;
    private final int[] max_gray;
    private final int[] min_pixel;
    private final int[] min_gray;
    private final int[] r_sum;
    private final int[] g_sum;
    private final int[] b_sum;
    private final int in_width;
    private final int in_height;
    private final int start_x;
    private final int len_x;
    private final CountDownLatch scanning;

    public TileMMACombiner(int in_width, int in_height, int sx, int lx, CountDownLatch scanning, int[] argbArray, int[] max_pixel, int[] max_gray, int[] min_pixel, int[] min_gray, int[] r_sum, int[] g_sum, int[] b_sum) {
        this.in_width = in_width;
        this.in_height = in_height;
        this.start_x = sx;
        this.len_x = lx;
        this.scanning = scanning;
        this.argbArray = argbArray;
        this.max_pixel = max_pixel;
        this.max_gray = max_gray;
        this.min_pixel = min_pixel;
        this.min_gray = min_gray;
        this.r_sum = r_sum;
        this.g_sum = g_sum;
        this.b_sum = b_sum;
    }

    @Override
    public void run() {
        try {
            int ix = 0;
            while (ix < this.len_x) {
                int iy = 0;
                while (iy < this.in_height) {
                    int po = iy * this.in_width + ix + this.start_x;
                    int pi = 3 * po;
                    int gray = this.argbArray[pi] + this.argbArray[pi + 1] + this.argbArray[pi + 2];
                    if (this.max_gray[po] < gray) {
                        this.max_gray[po] = gray;
                        this.max_pixel[po] = (this.argbArray[pi] & 0xFF) << 16 | (this.argbArray[pi + 1] & 0xFF) << 8 | this.argbArray[pi + 2] & 0xFF | 0xFF000000;
                    }
                    if (this.min_gray[po] > gray) {
                        this.min_gray[po] = gray;
                        this.min_pixel[po] = (this.argbArray[pi] & 0xFF) << 16 | (this.argbArray[pi + 1] & 0xFF) << 8 | this.argbArray[pi + 2] & 0xFF | 0xFF000000;
                    }
                    int n = po;
                    this.r_sum[n] = this.r_sum[n] + this.argbArray[pi];
                    int n2 = po;
                    this.g_sum[n2] = this.g_sum[n2] + this.argbArray[pi + 1];
                    int n3 = po;
                    this.b_sum[n3] = this.b_sum[n3] + this.argbArray[pi + 2];
                    ++iy;
                }
                ++ix;
            }
        }
        finally {
            this.scanning.countDown();
        }
    }

    @Override
    public String toString() {
        return "TileCombiner [in_width=" + this.in_width + ", in_height=" + this.in_height + ", start_x=" + this.start_x + ", len_x=" + this.len_x + ", scanning=" + String.valueOf(this.scanning) + "]";
    }
}

