/*
 * Decompiled with CFR 0.152.
 */
package slitscan.concombine;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import slitscan.CombineRoot;
import slitscan.ConCombine;
import slitscan.concombine.TileMMACombiner;

public class MMA
extends CombineRoot
implements ConCombine {
    static final int ap = Runtime.getRuntime().availableProcessors();
    File[] in_files;
    int[] max_pixel;
    int[] max_gray;
    int[] min_pixel;
    int[] min_gray;
    int[] r_sum;
    int[] g_sum;
    int[] b_sum;
    int count;

    public MMA(File[] in_files, String[] args) {
        this.in_files = in_files;
    }

    @Override
    public void pre() throws IOException {
        int size = this.octx.width * this.octx.height;
        this.max_pixel = new int[size];
        this.max_gray = new int[size];
        this.min_pixel = new int[size];
        this.min_gray = new int[size];
        Arrays.fill(this.min_gray, Integer.MAX_VALUE);
        this.r_sum = new int[size];
        this.g_sum = new int[size];
        this.b_sum = new int[size];
        this.count = 0;
    }

    @Override
    public void combine() throws IOException {
        int[] argbArray = null;
        int fx = 0;
        while (fx < this.in_files.length) {
            try {
                BufferedImage in_image = ImageIO.read(this.in_files[fx]);
                int in_width = in_image.getWidth();
                int in_height = in_image.getHeight();
                if (argbArray == null) {
                    argbArray = new int[3 * in_width * in_height];
                }
                Raster raster = in_image.getData();
                raster.getPixels(0, 0, in_width, in_height, argbArray);
                TileMMACombiner[] parallelCombiner = new TileMMACombiner[ap];
                CountDownLatch combining = new CountDownLatch(parallelCombiner.length);
                int per = in_width / ap;
                int rest = in_width - per * (ap - 1);
                int sx1 = 0;
                while (sx1 < parallelCombiner.length - 1) {
                    parallelCombiner[sx1] = new TileMMACombiner(in_width, in_height, sx1 * per, per, combining, argbArray, this.max_pixel, this.max_gray, this.min_pixel, this.min_gray, this.r_sum, this.g_sum, this.b_sum);
                    parallelCombiner[sx1].start();
                    ++sx1;
                }
                parallelCombiner[sx1] = new TileMMACombiner(in_width, in_height, sx1 * per, rest, combining, argbArray, this.max_pixel, this.max_gray, this.min_pixel, this.min_gray, this.r_sum, this.g_sum, this.b_sum);
                parallelCombiner[sx1].start();
                try {
                    combining.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++this.count;
                in_image.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++fx;
        }
    }

    @Override
    public int[] post(int i) throws IOException {
        switch (i) {
            case 0: {
                return this.max_pixel;
            }
            case 1: {
                return this.min_pixel;
            }
            case 2: {
                int[] pixels = new int[this.octx.width * this.octx.height];
                int pi = 0;
                while (pi < pixels.length) {
                    pixels[pi] = (this.r_sum[pi] / this.count & 0xFF) << 16 | (this.g_sum[pi] / this.count & 0xFF) << 8 | this.b_sum[pi] / this.count & 0xFF | 0xFF000000;
                    ++pi;
                }
                return pixels;
            }
        }
        return null;
    }

    @Override
    public String name(int i) {
        switch (i) {
            case 0: {
                return "max";
            }
            case 1: {
                return "min";
            }
            case 2: {
                return "avr";
            }
        }
        return "";
    }

    public String toString() {
        return "MMA";
    }
}

