/*
 * Decompiled with CFR 0.152.
 */
package slitscan.concombine;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import javax.imageio.ImageIO;
import slitscan.CombineRoot;
import slitscan.ConCombine;
import slitscan.concombine.TileStopsCombiner;

public class Flash
extends CombineRoot
implements ConCombine {
    static final int ap = Runtime.getRuntime().availableProcessors();
    File[] in_files;
    double[] r_sum;
    double[] g_sum;
    double[] b_sum;
    int count;
    private final int nstops;
    private final int width;
    private final double weight;
    private final int[] lower;
    private final int[] upper;

    public Flash(File[] in_files, String[] args) {
        this.in_files = in_files;
        this.nstops = this.checkArg(args, 0) ? Integer.parseInt(args[0]) : -1;
        this.width = Math.max(0, this.checkArg(args, 1) ? Integer.parseInt(args[1]) : 1);
        double d = this.weight = this.checkArg(args, 2) ? Double.parseDouble(args[2]) : 1.0;
        if (this.nstops > 0) {
            this.lower = new int[this.nstops];
            this.upper = new int[this.nstops];
            int pos = 0;
            int delta = in_files.length / (this.nstops + 1);
            int wl = this.width / 2;
            int wu = this.width - wl;
            int si = 0;
            while (si < this.nstops) {
                this.lower[si] = (pos += delta) - wl;
                this.upper[si] = pos + wu;
                ++si;
            }
        } else {
            this.lower = null;
            this.upper = null;
        }
    }

    boolean inside(int fx) {
        int si = 0;
        while (si < this.nstops) {
            if (fx > this.lower[si] && fx <= this.upper[si]) {
                return true;
            }
            ++si;
        }
        return false;
    }

    @Override
    public void pre() throws IOException {
        int size = this.octx.width * this.octx.height;
        this.r_sum = new double[size];
        this.g_sum = new double[size];
        this.b_sum = new double[size];
        this.count = 0;
    }

    @Override
    public void combine() throws IOException {
        int[] argbArray = null;
        int flen = this.in_files.length;
        int fx = 0;
        while (fx < flen) {
            try {
                double w;
                if (this.inside(fx)) {
                    w = this.weight;
                    this.count = (int)((double)this.count + this.weight);
                } else {
                    w = 1.0;
                    ++this.count;
                }
                BufferedImage in_image = ImageIO.read(this.in_files[fx]);
                int in_width = in_image.getWidth();
                int in_height = in_image.getHeight();
                if (argbArray == null) {
                    argbArray = new int[3 * in_width * in_height];
                }
                Raster raster = in_image.getData();
                raster.getPixels(0, 0, in_width, in_height, argbArray);
                TileStopsCombiner[] parallelCombiner = new TileStopsCombiner[ap];
                CountDownLatch combining = new CountDownLatch(parallelCombiner.length);
                int per = in_width / ap;
                int rest = in_width - per * (ap - 1);
                int sx1 = 0;
                while (sx1 < parallelCombiner.length - 1) {
                    parallelCombiner[sx1] = new TileStopsCombiner(in_width, in_height, sx1 * per, per, combining, argbArray, w, this.r_sum, this.g_sum, this.b_sum);
                    parallelCombiner[sx1].start();
                    ++sx1;
                }
                parallelCombiner[sx1] = new TileStopsCombiner(in_width, in_height, sx1 * per, rest, combining, argbArray, w, this.r_sum, this.g_sum, this.b_sum);
                parallelCombiner[sx1].start();
                try {
                    combining.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                in_image.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++fx;
        }
    }

    @Override
    public int[] post(int i) throws IOException {
        if (i != 0) {
            return null;
        }
        int[] pixels = new int[this.octx.width * this.octx.height];
        int pi = 0;
        while (pi < pixels.length) {
            pixels[pi] = ((int)(this.r_sum[pi] / (double)this.count) & 0xFF) << 16 | ((int)(this.g_sum[pi] / (double)this.count) & 0xFF) << 8 | (int)(this.b_sum[pi] / (double)this.count) & 0xFF | 0xFF000000;
            ++pi;
        }
        return pixels;
    }

    @Override
    public String name(int i) {
        return "";
    }

    public String toString() {
        return "Flash [nstops=" + this.nstops + ", width=" + this.width + ", weight=" + this.weight + "]";
    }
}

