/*
 * Decompiled with CFR 0.152.
 */
package slitscan.combine;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import slitscan.CombineRoot;
import slitscan.ConCombine;
import slitscan.combine.Pixel;
import slitscan.combine.Position;
import slitscan.combine.SortByGray;

public class Median
extends CombineRoot
implements ConCombine {
    File[] in_files;
    Position[] pl;

    public Median(File[] in_files, String[] args) {
        this.in_files = in_files;
    }

    @Override
    public void pre() throws IOException {
        this.pl = new Position[this.octx.width * this.octx.height];
        int ix = 0;
        while (ix < this.octx.width) {
            int iy = 0;
            while (iy < this.octx.height) {
                int si = iy * this.octx.width + ix;
                this.pl[si] = new Position(ix, iy, this.in_files.length);
                ++iy;
            }
            ++ix;
        }
    }

    @Override
    public void combine() throws IOException {
        int[] argbArray = null;
        int fx = 0;
        while (fx < this.in_files.length) {
            try {
                BufferedImage in_image = ImageIO.read(this.in_files[fx]);
                int in_width = in_image.getWidth();
                int in_height = in_image.getHeight();
                if (argbArray == null) {
                    argbArray = new int[3 * in_width * in_height];
                }
                Raster raster = in_image.getData();
                raster.getPixels(0, 0, in_width, in_height, argbArray);
                int ix = 0;
                while (ix < in_width) {
                    int iy = 0;
                    while (iy < in_height) {
                        int po = iy * in_width + ix;
                        int pi = 3 * po;
                        Position p = this.pl[po];
                        p.pixelList[p.append++] = new Pixel(argbArray[pi], argbArray[pi + 1], argbArray[pi + 2], (short)fx);
                        ++iy;
                    }
                    ++ix;
                }
                in_image.flush();
                System.out.println(this.in_files[fx]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++fx;
        }
        int pi = 0;
        while (pi < this.pl.length) {
            Arrays.sort(this.pl[pi].pixelList, new SortByGray());
            ++pi;
        }
    }

    @Override
    public int[] post(int i) throws IOException {
        if (i == 0) {
            int[] pixels = new int[this.octx.width * this.octx.height];
            int pi = 0;
            while (pi < pixels.length) {
                Pixel[] pl = this.pl[pi].pixelList;
                pixels[pi] = pl[pl.length / 2].argb;
                ++pi;
            }
            return pixels;
        }
        return null;
    }

    @Override
    public String name(int i) {
        return "";
    }

    public String toString() {
        return "Median []";
    }
}

