/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import java.util.concurrent.CountDownLatch;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.Orbit;
import slitscan.Point;

class TileScanner
extends Thread {
    final int start_x;
    final int len_x;
    final int start_y;
    final int len_y;
    final Orbit orbit1;
    final Orbit orbit2;
    final double mix;
    final ContextIn ictx;
    final ContextOut octx;
    final CountDownLatch scanning;
    final CountDownLatch merging;
    int count;
    Point anchor;

    public TileScanner(Orbit orbit1, Orbit orbit2, double mix, ContextIn ictx, ContextOut octx, int lx, int ux, int ly, int uy, CountDownLatch scanning, CountDownLatch merging) {
        this.orbit1 = orbit1;
        this.orbit2 = orbit2;
        this.mix = mix;
        this.ictx = ictx;
        this.octx = octx;
        this.start_x = lx;
        this.len_x = ux;
        this.start_y = ly;
        this.len_y = uy;
        this.scanning = scanning;
        this.merging = merging;
    }

    @Override
    public void run() {
        try {
            this.count = 0;
            int ix = 0;
            while (ix < this.len_x) {
                int iy = 0;
                while (iy < this.len_y) {
                    Point p1 = new Point(this.anchor, this.start_x + ix, this.start_y + iy);
                    this.orbit1.f(p1);
                    if (this.orbit2 != null) {
                        Point p2 = new Point(this.anchor, this.start_x + ix, this.start_y + iy);
                        this.orbit2.f(p2);
                        p1.sx = (int)(this.mix * (double)p1.sx + (1.0 - this.mix) * (double)p2.sx);
                        p1.sy = (int)(this.mix * (double)p1.sy + (1.0 - this.mix) * (double)p2.sy);
                        p1.sz = this.mix * p1.sz + (1.0 - this.mix) * p2.sz;
                    }
                    this.anchor = p1;
                    ++this.count;
                    ++iy;
                }
                ++ix;
            }
        }
        finally {
            this.scanning.countDown();
        }
        try {
            this.merging.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

