/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import slitscan.Point;

class TileMapper
extends Thread {
    final Point[] points;
    final File[] in_files;
    final int[] pixels;
    final CountDownLatch mapping;
    final AtomicInteger load_counter;
    final int start;
    final int len;
    final int stride;

    public TileMapper(Point[] points, File[] in_files, int[] pixels, int start, int len, int stride, CountDownLatch mapping, AtomicInteger load_counter) {
        this.points = points;
        this.in_files = in_files;
        this.pixels = pixels;
        this.start = start;
        this.len = len;
        this.stride = stride;
        this.mapping = mapping;
        this.load_counter = load_counter;
    }

    @Override
    public void run() {
        try {
            int current = Integer.MIN_VALUE;
            BufferedImage in_image = null;
            int width = 0;
            int height = 0;
            int px = 0;
            while (px < this.len) {
                Point point = this.points[px + this.start];
                if (current != (int)point.sz) {
                    try {
                        in_image = ImageIO.read(this.in_files[TileMapper.clamp((int)point.sz, this.in_files.length)]);
                        width = in_image.getWidth();
                        height = in_image.getHeight();
                        current = (int)point.sz;
                        this.load_counter.incrementAndGet();
                    }
                    catch (IOException e) {
                        in_image = null;
                        e.printStackTrace();
                    }
                }
                if (in_image != null) {
                    this.pixels[point.ty * this.stride + point.tx] = in_image.getRGB(TileMapper.clamp(point.sx, width), TileMapper.clamp(point.sy, height));
                }
                ++px;
            }
        }
        finally {
            this.mapping.countDown();
        }
    }

    static int clamp(int val, int limit) {
        if (val < 0) {
            return 0;
        }
        if (val >= limit) {
            return limit - 1;
        }
        return val;
    }
}

