/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import application.SL;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import slitscan.ContextIn;
import slitscan.ContextOut;
import slitscan.ExternalTracker;
import slitscan.Orbit;
import slitscan.Point;
import slitscan.TileMapper;
import slitscan.TileScanner;
import slitscan.func.Func;

public class OrbitScanner {
    static final int ap = Runtime.getRuntime().availableProcessors();

    public static void work(File[] in_files, Orbit orbit1, Orbit orbit2, double mix, String range_label, String tracker_fn) {
        System.out.println("cores  = " + ap);
        assert (ap > 0) : ap;
        assert (in_files != null && in_files.length > 0);
        try {
            System.out.println("images = " + in_files.length);
            long t0 = System.nanoTime();
            ContextIn ictx = new ContextIn(in_files);
            System.out.println("in     = " + String.valueOf(ictx));
            orbit1.setTracker(ExternalTracker.buildTracker(tracker_fn, ictx));
            ContextOut octx = orbit1.buildContextOut(ictx);
            if (orbit2 != null) {
                orbit2.buildContextOut(ictx);
            }
            System.out.println("out    = " + String.valueOf(octx));
            long t1 = System.nanoTime();
            System.out.println("cntx   = " + (double)(t1 - t0) / 1000000.0);
            Object[] points = OrbitScanner.scan(orbit1, orbit2, mix, ictx, octx);
            long t2 = System.nanoTime();
            System.out.println("scan   = " + (double)(t2 - t1) / 1000000.0);
            Arrays.sort(points);
            long t3 = System.nanoTime();
            System.out.println("sort   = " + (double)(t3 - t2) / 1000000.0);
            int[] pixels = OrbitScanner.map((Point[])points, in_files, octx);
            long t4 = System.nanoTime();
            System.out.println("map    = " + (double)(t4 - t3) / 1000000.0);
            BufferedImage out_iamge = new BufferedImage(octx.width, octx.height, 2);
            out_iamge.setRGB(0, 0, octx.width, octx.height, pixels, 0, octx.width);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HHmmss");
            Object m = "";
            if (orbit2 != null) {
                m = "(mix=" + mix + ")" + String.valueOf(orbit2);
            }
            Object output_name = SL.out_path + "orbit-" + String.valueOf(orbit1) + (String)m + range_label + "-" + sdf.format(new Date()) + ".png";
            output_name = ((String)output_name).replace(" ", "");
            ImageIO.write((RenderedImage)out_iamge, "png", new File((String)output_name));
            long t5 = System.nanoTime();
            System.out.println("write  = " + (double)(t5 - t4) / 1000000.0);
            System.out.println("output = " + (String)output_name);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Point[] scan(Orbit orbit1, Orbit orbit2, double mix, ContextIn ictx, ContextOut octx) {
        boolean normalize;
        assert (orbit1 != null);
        TileScanner[] parallelScanner = new TileScanner[ap];
        CountDownLatch scanning = new CountDownLatch(parallelScanner.length);
        CountDownLatch[] merging = new CountDownLatch[parallelScanner.length];
        int per = octx.width / ap;
        int rest = octx.width - per * (ap - 1);
        int sx1 = 0;
        while (sx1 < parallelScanner.length - 1) {
            merging[sx1] = new CountDownLatch(1);
            parallelScanner[sx1] = new TileScanner(orbit1, orbit2, mix, ictx, octx, sx1 * per, per, 0, octx.height, scanning, merging[sx1]);
            parallelScanner[sx1].start();
            ++sx1;
        }
        sx1 = parallelScanner.length - 1;
        merging[sx1] = new CountDownLatch(1);
        parallelScanner[sx1] = new TileScanner(orbit1, orbit2, mix, ictx, octx, sx1 * per, rest, 0, octx.height, scanning, merging[sx1]);
        parallelScanner[sx1].start();
        try {
            scanning.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int count = 0;
        int sx2 = 0;
        while (sx2 < parallelScanner.length) {
            count += parallelScanner[sx2].count;
            ++sx2;
        }
        Point[] points = new Point[count];
        int px = 0;
        int sx3 = 0;
        while (sx3 < parallelScanner.length) {
            Point p = parallelScanner[sx3].anchor;
            while (p != null) {
                points[px++] = p;
                p = p.next;
            }
            merging[sx3].countDown();
            ++sx3;
        }
        boolean bl = normalize = orbit1 instanceof Func || orbit2 instanceof Func;
        if (normalize) {
            boolean FUNC_DUMP = false;
            double maxsz = Double.MIN_VALUE;
            double minsz = Double.MAX_VALUE;
            int pi = 0;
            while (pi < points.length) {
                if (points[pi].sz > maxsz) {
                    maxsz = points[pi].sz;
                }
                if (points[pi].sz < minsz) {
                    minsz = points[pi].sz;
                }
                ++pi;
            }
            double diffsz = maxsz - minsz;
            double factorsz = (double)ictx.depth / diffsz;
            int pi2 = 0;
            while (pi2 < points.length) {
                points[pi2].sz = factorsz * (points[pi2].sz - minsz);
                ++pi2;
            }
        }
        return points;
    }

    private static int[] map(Point[] points, File[] in_files, ContextOut ctx) {
        assert (points != null);
        assert (in_files != null);
        int[] pixels = new int[ctx.width * ctx.height];
        int ap2 = ap + ap / 4;
        int per = points.length / ap2;
        int rest = points.length - per * (ap2 - 1);
        TileMapper[] parallelMapper = new TileMapper[ap2];
        CountDownLatch mapping = new CountDownLatch(parallelMapper.length);
        AtomicInteger load_counter = new AtomicInteger(0);
        int mx = 0;
        while (mx < parallelMapper.length - 1) {
            parallelMapper[mx] = new TileMapper(points, in_files, pixels, mx * per, per, ctx.width, mapping, load_counter);
            parallelMapper[mx].start();
            ++mx;
        }
        parallelMapper[parallelMapper.length - 1] = new TileMapper(points, in_files, pixels, (ap2 - 1) * per, rest, ctx.width, mapping, load_counter);
        parallelMapper[parallelMapper.length - 1].start();
        try {
            mapping.await();
            System.out.println("loads  = " + load_counter.get());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return pixels;
    }
}

