/*
 * Decompiled with CFR 0.152.
 */
package slitscan;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import slitscan.ContextIn;
import slitscan.FramePosition;

public class ExternalTracker {
    ContextIn ictx;
    FramePosition[] frames;

    ExternalTracker(ContextIn ictx) {
        this.ictx = ictx;
        this.frames = new FramePosition[this.ictx.depth];
    }

    private int clamp(int f) {
        if (f < 0) {
            return 0;
        }
        if (f >= this.frames.length) {
            return this.frames.length - 1;
        }
        return f;
    }

    public int xAt(int frame, int factor) {
        return (int)(this.frames[this.clamp((int)frame)].x * (double)factor);
    }

    public int xNear(double frame) {
        double min = Double.MAX_VALUE;
        int at = 0;
        int ff = 0;
        while (ff < this.frames.length) {
            double diff = Math.abs(this.frames[ff].x - frame);
            if (diff < min) {
                min = diff;
                at = this.frames[ff].frame;
            }
            ++ff;
        }
        return at;
    }

    public int yNear(double frame) {
        double min = Double.MAX_VALUE;
        int at = 0;
        int ff = 0;
        while (ff < this.frames.length) {
            double diff = Math.abs(this.frames[ff].y - frame);
            if (diff < min) {
                min = diff;
                at = this.frames[ff].frame;
            }
            ++ff;
        }
        return at;
    }

    public int yAt(int frame, int factor) {
        return (int)(this.frames[this.clamp((int)frame)].y * (double)factor);
    }

    private void readTracker(String tracker_fn) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(tracker_fn));){
                String line = br.readLine();
                while (line != null) {
                    int f;
                    String[] s;
                    if (line.length() >= 1 && !line.startsWith("<") && (s = line.split(" ")).length == 3 && (f = Integer.parseInt(s[0])) < this.ictx.depth) {
                        double x = Double.parseDouble(s[1]);
                        double y = Double.parseDouble(s[2]);
                        if (this.frames[f] == null) {
                            this.frames[f] = new FramePosition(f, x, y);
                        } else {
                            this.frames[f].x += x;
                            this.frames[f].y += y;
                            ++this.frames[f].occurrences;
                        }
                    }
                    line = br.readLine();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int ff = 0;
        while (ff < this.ictx.depth) {
            if (this.frames[ff] != null && this.frames[ff].occurrences > 1) {
                this.frames[ff].x /= (double)this.frames[ff].occurrences;
                this.frames[ff].y /= (double)this.frames[ff].occurrences;
                this.frames[ff].occurrences = 1;
            }
            ++ff;
        }
    }

    private void intrepolate() {
        int gap_start = -1;
        int gap_end = -1;
        int ff = 0;
        while (ff < this.ictx.depth) {
            if (gap_start == -1 && this.frames[ff] == null) {
                gap_start = ff;
            } else if (gap_start != -1 && gap_end != -1 && this.frames[ff] != null) {
                gap_end = ff;
                double dx = (this.frames[gap_end].x - this.frames[gap_start - 1].x) / (double)(gap_end - gap_start + 1);
                double dy = (this.frames[gap_end].y - this.frames[gap_start - 1].y) / (double)(gap_end - gap_start + 1);
                System.out.println(gap_start + " " + gap_end);
                int step = 1;
                System.out.println(gap_start - 1 + " " + String.valueOf(this.frames[gap_start - 1]));
                int gx = gap_start;
                while (gx < gap_end) {
                    this.frames[gx] = new FramePosition(this.frames[gap_start - 1].frame + step, this.frames[gap_start - 1].x + dx * (double)step, this.frames[gap_start - 1].y + dy * (double)step);
                    System.out.println(gx + " " + String.valueOf(this.frames[gx]));
                    ++step;
                    ++gx;
                }
                System.out.println(gap_end + " " + String.valueOf(this.frames[gap_end]));
                gap_start = -1;
                gap_end = -1;
            }
            ++ff;
        }
        ff = 1;
        while (ff < this.ictx.depth) {
            if (this.frames[ff] == null && this.frames[ff - 1] != null) {
                this.frames[ff] = new FramePosition(this.frames[ff - 1].frame + 1, this.frames[ff - 1].x, this.frames[ff - 1].y);
            }
            ++ff;
        }
        System.out.println(this.frames.length - 1 + " " + String.valueOf(this.frames[this.frames.length - 1]));
    }

    private void checkConsistency() {
        assert (this.frames.length == this.ictx.depth);
        int ff = 0;
        while (ff < this.frames.length) {
            assert (this.frames[ff] != null);
            assert (this.frames[ff].frame == ff);
            ++ff;
        }
    }

    public void doSmoothing() {
        FramePosition[] sf = new FramePosition[this.frames.length];
        int ff = 0;
        while (ff < this.frames.length) {
            sf[ff] = new FramePosition(this.frames[ff]);
            ++ff;
        }
        ff = 2;
        while (ff < this.frames.length - 2) {
            double x = (this.frames[ff - 2].x + 2.0 * this.frames[ff - 1].x + 4.0 * this.frames[ff].x + 2.0 * this.frames[ff + 1].x + this.frames[ff + 2].x) / 10.0;
            double y = (this.frames[ff - 2].y + 2.0 * this.frames[ff - 1].y + 4.0 * this.frames[ff].y + 2.0 * this.frames[ff + 1].y + this.frames[ff + 2].y) / 10.0;
            sf[ff] = new FramePosition(ff, x, y);
            ++ff;
        }
        this.frames = sf;
    }

    public void normalize() {
        double xmin = this.frames[0].x;
        double xmax = this.frames[0].x;
        double ymin = this.frames[0].y;
        double ymax = this.frames[0].y;
        int ff = 1;
        while (ff < this.frames.length) {
            if (this.frames[ff].x < xmin) {
                xmin = this.frames[ff].x;
            }
            if (this.frames[ff].x > xmax) {
                xmax = this.frames[ff].x;
            }
            if (this.frames[ff].y < ymin) {
                ymin = this.frames[ff].y;
            }
            if (this.frames[ff].y > ymax) {
                ymax = this.frames[ff].y;
            }
            ++ff;
        }
        double xrange = xmax - xmin;
        double yrange = ymax - ymin;
        int ff2 = 0;
        while (ff2 < this.frames.length) {
            this.frames[ff2].x = (this.frames[ff2].x - xmin) / xrange;
            this.frames[ff2].y = (this.frames[ff2].y - ymin) / yrange;
            ++ff2;
        }
    }

    void build0(String tracker_fn, ExternalTracker tracker) {
        this.readTracker(tracker_fn);
        this.intrepolate();
        this.checkConsistency();
        this.checkConsistency();
    }

    static ExternalTracker buildTracker(String tracker_fn, ContextIn ictx) {
        if (tracker_fn != null && tracker_fn.length() > 0) {
            ExternalTracker tracker = new ExternalTracker(ictx);
            tracker.build0(tracker_fn, tracker);
            return tracker;
        }
        return null;
    }
}

